#
# Enhydra Java Application Server 
# The Initial Developer of the Original Code is Lutris Technologies Inc. 
# Portions created by Lutris are Copyright (C) 1997-2000 Lutris Technologies
# Inc. 
# All Rights Reserved. 
#
# The contents of this file are subject to the Enhydra Public License Version
# 1.0 (the "License"); you may not use this file except in compliance with the
# License. You may obtain a copy of the License at
# http://www.enhydra.org/software/license/epl.html 
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
# License for the specific language governing rights and limitations under the
# License. 
#

# Include this after your
# include $(ENHYDRA_DIR)/lib/stdrules.mk
# line in your config.mk or after your
# include $(ROOT)/config.mk 
# in each specific Makefile that needs 
# to build XML files
# ---------------------------
#
# BEGIN XML build rules
#


$(PACKAGE_OUTPUT)/%XML.class: $(XML_DIR)/%.xml $(XMLC_XML_OPTS_FILE) $(XMLC_%_OPTS_FILE)
	@mkdir -p $(PACKAGE_OUTPUT)
ifeq ($(XMLC_AUTO_COMP),YES)
	cp -f $(XML_DIR)/$*.xml	$(PACKAGE_OUTPUT)
endif
		@CLASSPATH="$(ENHYDRA_CLASSPATH)" ;	export CLASSPATH ; \
		set	-x ; \
		$(XMLC_CMD)	-class $(PACKAGE).$*XML	$(XMLC_XML_OPTS) $(XMLC_$*_OPTS) $(XMLC_JAVAC) $(XMLC_XML_OPTS_FILE) $(XMLC_$*_OPTS_FILE) $(XML_DIR)/$*.xml

$(PACKAGE_OUTPUT)/%XML.class: %.xml	$(XMLC_XML_OPTS_FILE)
		@mkdir -p $(PACKAGE_OUTPUT)
		@CLASSPATH="$(ENHYDRA_CLASSPATH)" ;	export CLASSPATH ; \
		set	-x ; \
		$(XMLC_CMD)	-class $(PACKAGE).$*XML	-d $(PACKAGE_OUTPUT) $(XMLC_XML_OPTS) $(XMLC_$*_OPTS) $(XMLC_JAVAC)	$(XMLC_XML_OPTS_FILE)  $*.xml

do_xmlc_html_targets:: $(XML_CLASSES:%=${PACKAGE_OUTPUT}/%.class)

# END XML build rules